/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.command;

import cofh.core.RegistrySocial;
import cofh.core.command.CommandHandler;
import cofh.core.command.ISubCommand;
import cofh.core.util.oredict.OreDictionaryArbiter;
import cofh.lib.util.helpers.ItemHelper;
import cofh.lib.util.helpers.StringHelper;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.event.HoverEvent;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;

public class CommandHand
implements ISubCommand {
    public static ISubCommand instance = new CommandHand();
    private static HashMap<String, InfoType> infoMap = new HashMap();

    @Override
    public String getCommandName() {
        return "hand";
    }

    @Override
    public int getPermissionLevel() {
        return 0;
    }

    @Override
    public void handleCommand(ICommandSender iCommandSender, String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        EntityPlayerMP entityPlayerMP = null;
        ItemStack itemStack = null;
        switch (n) {
            case 0: {
                iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
            }
            default: {
                try {
                    entityPlayerMP = CommandBase.getPlayer((ICommandSender)iCommandSender, (String)stringArray[++n2]);
                }
                catch (CommandException commandException) {
                    if (!infoMap.containsKey(stringArray[n2])) {
                        throw commandException;
                    }
                    --n2;
                }
                if (entityPlayerMP == null || entityPlayerMP == iCommandSender || CommandHandler.canUseCommand(iCommandSender, 1, this.getCommandName()) || RegistrySocial.playerHasAccess(iCommandSender.getCommandSenderName(), entityPlayerMP.getGameProfile())) break;
                throw new CommandException("commands.generic.permission", new Object[0]);
            }
            case 1: 
        }
        if (entityPlayerMP == null) {
            entityPlayerMP = CommandBase.getCommandSenderAsPlayer((ICommandSender)iCommandSender);
        }
        if ((itemStack = entityPlayerMP.getCurrentEquippedItem()) == null) {
            iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("commands.enchant.noItem", new Object[0]));
            return;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (++n2 == n) {
            arrayList.add((Object)InfoType.Name);
        } else {
            while (n2 < n) {
                Object object = infoMap.get(stringArray[n2].toLowerCase());
                if (object == null) {
                    iCommandSender.addChatMessage((IChatComponent)new ChatComponentTranslation("info.cofh.command.syntaxError", new Object[0]));
                    throw new WrongUsageException("info.cofh.command." + this.getCommandName() + ".syntax", new Object[0]);
                }
                arrayList.add(object);
                ++n2;
            }
        }
        for (InfoType infoType : arrayList) {
            IChatComponent[] iChatComponentArray = infoType.getData(itemStack);
            ChatComponentText chatComponentText = new ChatComponentText(infoType.name() + ": ");
            if (iChatComponentArray.length >= 1 && iChatComponentArray[0] != null) {
                chatComponentText.appendSibling(iChatComponentArray[0]);
            }
            iCommandSender.addChatMessage((IChatComponent)chatComponentText);
            for (n2 = 1; n2 < iChatComponentArray.length; ++n2) {
                iCommandSender.addChatMessage(iChatComponentArray[n2]);
            }
        }
    }

    @Override
    public List<String> addTabCompletionOptions(ICommandSender iCommandSender, String[] stringArray) {
        if (stringArray.length == 2) {
            return CommandBase.getListOfStringsMatchingLastWord((String[])stringArray, (String[])MinecraftServer.getServer().getAllUsernames());
        }
        return CommandBase.getListOfStringsFromIterableMatchingLastWord((String[])stringArray, infoMap.keySet());
    }

    static {
        InfoType.values();
    }

    private static enum InfoType {
        Name(new String[]{"generic"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                ChatComponentText chatComponentText = new ChatComponentText("");
                chatComponentText.appendSibling(itemStack.func_151000_E());
                if (itemStack.hasDisplayName()) {
                    String string = itemStack.getItem().getUnlocalizedName(itemStack);
                    if (!StatCollector.canTranslate((String)string)) {
                        string = string + ".name";
                    }
                    ChatComponentTranslation chatComponentTranslation = new ChatComponentTranslation(string, new Object[0]);
                    chatComponentTranslation.getChatStyle().setChatHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)new ChatComponentText(string)));
                    chatComponentText.appendText(" (").appendSibling((IChatComponent)chatComponentTranslation).appendText(")");
                }
                return chatComponentText;
            }
        }
        ,
        Id{

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(Item.itemRegistry.getNameForObject((Object)itemStack.getItem()));
            }
        }
        ,
        Size(new String[]{"amount", "count"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(String.valueOf(itemStack.stackSize));
            }
        }
        ,
        Metadata(new String[]{"damage", "alt"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(String.valueOf(ItemHelper.getItemDamage(itemStack)));
            }
        }
        ,
        toString(new String[]{"string", "text"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(itemStack.toString());
            }
        }
        ,
        Action(new String[]{"use"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                EnumAction enumAction = itemStack.getItemUseAction();
                ChatComponentText chatComponentText = new ChatComponentText(enumAction.name());
                if (enumAction != EnumAction.none) {
                    chatComponentText.appendText(" | Duration: " + itemStack.getMaxItemUseDuration());
                }
                return chatComponentText;
            }
        }
        ,
        Lore(new String[]{"flavorText"}){

            @Override
            public IChatComponent[] getData(ItemStack itemStack) {
                LinkedList<ChatComponentText> linkedList = new LinkedList<ChatComponentText>();
                linkedList.add(null);
                if (itemStack.hasTagCompound() && itemStack.stackTagCompound.hasKey("display", 10)) {
                    NBTTagList nBTTagList;
                    NBTTagCompound nBTTagCompound = itemStack.stackTagCompound.getCompoundTag("display");
                    if (nBTTagCompound.func_150299_b("Lore") == 9 && (nBTTagList = nBTTagCompound.getTagList("Lore", 8)).tagCount() > 0) {
                        for (int i = 0; i < nBTTagList.tagCount(); ++i) {
                            linkedList.add(new ChatComponentText("\u00a75      \u00a7o" + nBTTagList.getStringTagAt(i)));
                        }
                    }
                } else {
                    linkedList.set(0, new ChatComponentText("none"));
                }
                return linkedList.toArray(new IChatComponent[linkedList.size()]);
            }
        }
        ,
        Enchants(new String[]{"enchant", "ench"}){

            @Override
            public IChatComponent[] getData(ItemStack itemStack) {
                NBTTagList nBTTagList = itemStack.getEnchantmentTagList();
                LinkedList<ChatComponentText> linkedList = new LinkedList<ChatComponentText>();
                linkedList.add(null);
                if (nBTTagList != null && nBTTagList.tagCount() > 0) {
                    for (int i = 0; i < nBTTagList.tagCount(); ++i) {
                        short s = nBTTagList.getCompoundTagAt(i).getShort("id");
                        short s2 = nBTTagList.getCompoundTagAt(i).getShort("lvl");
                        if (Enchantment.enchantmentsList[s] != null) {
                            linkedList.add(new ChatComponentText("\u00a73     " + StatCollector.translateToLocal((String)Enchantment.enchantmentsList[s].getName()) + " " + StringHelper.toNumerals(s2)));
                            continue;
                        }
                        linkedList.add(new ChatComponentText("\u00a74     " + String.format("Invalid{id=%s,lvl=%s}", s, s2)));
                    }
                } else {
                    linkedList.set(0, new ChatComponentText("none"));
                }
                return linkedList.toArray(new IChatComponent[linkedList.size()]);
            }
        }
        ,
        NBT(new String[]{"tag", "stackTag", "compoundTag"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                return new ChatComponentText(Objects.toString(itemStack.getTagCompound(), "null"));
            }
        }
        ,
        OreDict(new String[]{"oreNames", "oreName", "ores", "ore"}){

            @Override
            public IChatComponent processStack(ItemStack itemStack) {
                ArrayList<String> arrayList = OreDictionaryArbiter.getAllOreNames(itemStack);
                int n = arrayList == null ? 0 : arrayList.size();
                String string = Objects.toString(arrayList, "[null]");
                return new ChatComponentText(n + "> " + string.substring(1, string.length() - 1));
            }
        }
        ,
        Modifiers{
            protected final UUID field_111210_e = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");

            @Override
            public IChatComponent[] getData(ItemStack itemStack) {
                LinkedList<ChatComponentText> linkedList = new LinkedList<ChatComponentText>();
                linkedList.add(null);
                Multimap multimap = itemStack.getAttributeModifiers();
                if (!multimap.isEmpty()) {
                    for (Map.Entry entry : multimap.entries()) {
                        AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                        double d = attributeModifier.getAmount();
                        if (this.field_111210_e.equals(attributeModifier.getID())) {
                            d += (double)EnchantmentHelper.func_152377_a((ItemStack)itemStack, (EnumCreatureAttribute)EnumCreatureAttribute.UNDEFINED);
                        }
                        double d2 = attributeModifier.getOperation() != 1 && attributeModifier.getOperation() != 2 ? d : d * 100.0;
                        if (d > 0.0) {
                            linkedList.add(new ChatComponentText("     \u00a79" + StatCollector.translateToLocalFormatted((String)("attribute.modifier.plus." + attributeModifier.getOperation()), (Object[])new Object[]{ItemStack.field_111284_a.format(d2), StatCollector.translateToLocal((String)("attribute.name." + (String)entry.getKey()))})));
                            continue;
                        }
                        if (!(d < 0.0)) continue;
                        d2 = -d2;
                        linkedList.add(new ChatComponentText("     \u00a7c" + StatCollector.translateToLocalFormatted((String)("attribute.modifier.take." + attributeModifier.getOperation()), (Object[])new Object[]{ItemStack.field_111284_a.format(d2), StatCollector.translateToLocal((String)("attribute.name." + (String)entry.getKey()))})));
                    }
                } else {
                    linkedList.set(0, new ChatComponentText("none"));
                }
                return linkedList.toArray(new IChatComponent[linkedList.size()]);
            }
        };


        private InfoType() {
            infoMap.put(this.name().toLowerCase(), this);
        }

        private InfoType(String ... stringArray) {
            this();
            for (String string2 : stringArray) {
                infoMap.put(string2.toLowerCase(), this);
            }
        }

        public IChatComponent processStack(ItemStack itemStack) {
            return null;
        }

        public IChatComponent[] getData(ItemStack itemStack) {
            return new IChatComponent[]{this.processStack(itemStack)};
        }
    }
}

